package com.vf106.tools.activity;

import android.Manifest;
import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.vf106.tools.R;
import com.vf106.tools.adapter.TestAdapter;
import com.vf106.tools.bean.BaseBean;
import com.vf106.tools.bean.DataBean;
import com.vf106.tools.utils.Constants;
import com.vf106.tools.utils.SPUtils;
import com.vf106.tools.utils.TtsManager;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends AppCompatActivity {
    public List<BaseBean> mData = new ArrayList<>();
    public RecyclerView rv;
    private TestAdapter adapter;
    private TextView tvPass;

    private int REQUEST_PERMISSION_CODE = 100;

    private static final int TTS_REQUEST_CODE = 1001;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        initView();
        initListener();
        initData();

        checkPermission();

        // Check if the TTS engine is installed
        Intent checkIntent = new Intent();
        checkIntent.setAction(TextToSpeech.Engine.ACTION_CHECK_TTS_DATA);
        startActivityForResult(checkIntent, TTS_REQUEST_CODE);
    }

    public void checkPermission() {
        // Check if permissions have been granted
        if (ContextCompat.checkSelfPermission(this, Manifest.permission.RECORD_AUDIO)
                != PackageManager.PERMISSION_GRANTED ||
                ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA)
                        != PackageManager.PERMISSION_GRANTED ||
                ContextCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE)
                        != PackageManager.PERMISSION_GRANTED) {
            // If permission is not granted, request permission
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.RECORD_AUDIO, Manifest.permission.CAMERA,
                            Manifest.permission.WRITE_EXTERNAL_STORAGE},
                    REQUEST_PERMISSION_CODE);
        } else {
            // If permissions have been granted, perform the appropriate action
            // Start recording, open the camera, write files, etc. here
        }
    }

    private void initView() {
        tvPass = findViewById(R.id.tv_pass);
        rv = findViewById(R.id.rv);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false);
        rv.setLayoutManager(layoutManager);
        adapter = new TestAdapter(mData);
        rv.setAdapter(adapter);
    }

    private void initListener() {
        adapter.setOnItemClickListener(new TestAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(View v, int position) {
                gotoActivity(position);
            }
        });
    }

    private void initData() {
        List<BaseBean> spList = SPUtils.getInstance().getList("testData");
        if (spList == null || spList.size() <= 0) {
            setData();
        } else {
            mData.addAll(spList);
            adapterNotifyChanged();
        }
    }

    private void setData() {
        String[] testValues = getResources().getStringArray(R.array.test_values);
        for (String testValue : testValues) {
            mData.add(new DataBean(testValue, 0));
        }
    }

    private void gotoActivity(int position) {
        BaseBean baseBean = mData.get(position);
        String[] testValues = getResources().getStringArray(R.array.test_values);
        if (baseBean.getName().equals(testValues[0])) { //Dual camera display test
            goActivity(CameraActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[1])) { //Fill light test
            goActivity(DeerActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[2])) { //Relay Testing
            goActivity(RelayActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[3])) { // OTG/HOST switching function
            goActivity(OtgActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[4])) { // Screen Touch Test
            goActivity(TouchActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[5])) { // Screen display test
            goActivity(ScreenActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[6])) { // Left and Right Channel Test
            goActivity(TrackMusicActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[7])) { // Temperature measurement function test
            goActivity(TemperatureActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[8])) { // RS232 function test
            goActivity(Rs232Activity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[9])) { // RS485 Function Test
            goActivity(Rs485Activity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[10])) { // Swipe Function Test
            goActivity(CardTestActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[11])) { // Code scanning function test
            goActivity(QrActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[12])) { // Alarm Function Test
            goActivity(WarnActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[13])) { // Equipment Information
            goActivity(DeviceInfoActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[14])) { // Recording function test
            goActivity(AudioRecordingActivity.class, position, baseBean.getName(), baseBean.getState());
        } else if (baseBean.getName().equals(testValues[15])) { // Text-to-Speech Playback Test
            goActivity(TtsVideoActivity.class, position, baseBean.getName(), baseBean.getState());
        }
    }

    public void goActivity(Class c, int position, String name, int state) {
        Intent intent = new Intent(this, c);
        intent.putExtra("position", position);
        intent.putExtra("name", name);
        intent.putExtra("state", state);
        startActivityForResult(intent, Constants.resultCode);
    }

    @SuppressLint("NotifyDataSetChanged")
    private void adapterNotifyChanged() {
        adapter.notifyDataSetChanged();
        int passNum = 0;
        for (int i = 0; i < mData.size(); i++) {
            int state = mData.get(i).getState();
            if (state == 1) {
                passNum++;
            }
        }
        String content = "satisfactory rate：" + (((float) passNum / mData.size() * 100)) + "%";
        SpannableStringBuilder builder = new SpannableStringBuilder(content);
        ForegroundColorSpan blackSpan = new ForegroundColorSpan(Color.parseColor("#000000"));
        ForegroundColorSpan buleSpan = new ForegroundColorSpan(Color.parseColor("#4d8ade"));

        builder.setSpan(blackSpan, 0, 3, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        builder.setSpan(buleSpan, 4, content.length(), Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
        tvPass.setText(builder);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == TTS_REQUEST_CODE) {
            if (resultCode == TextToSpeech.Engine.CHECK_VOICE_DATA_PASS) {
                // The TTS Engine is available
                // Here you can initialize the TTS Engine or perform other operations.
                // Example of initializing the TTS engine:
                // TextToSpeech tts = new TextToSpeech(this, null); // Initialize the speech engine.
                // Initialize the speech
                TtsManager.getInstance(this);

            } else if (resultCode == TextToSpeech.Engine.CHECK_VOICE_DATA_FAIL) {
                // TTS Engine check failed, prompting the user to install it.
                // The TTS Engine is not available, prompt the user to install the TTS Engine.
                Toast.makeText(this, "Please authorize the voice engine.", Toast.LENGTH_LONG).show();

            } else if (resultCode == RESULT_CANCELED) {
                // The user canceled the operation, you can handle the cancelation here
                Toast.makeText(this, "User Cancellation", Toast.LENGTH_LONG).show();

            }
            return;
        }

        if (data == null) {
            return;
        }
        if (Constants.resultCode == requestCode) {
            if (Constants.resultCode == resultCode) {
                String name = data.getStringExtra("name");
                int state = data.getIntExtra("state", 0);
                int position = data.getIntExtra("position", 0);
                mData.set(position, new BaseBean(name, state));
                SPUtils.getInstance().put("testData", mData);
            }
        }
        adapterNotifyChanged();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        SPUtils.getInstance().put("testData", mData);
    }
}